<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Inscription;
use App\Models\Message;
use App\Services\StatsService;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(StatsService $statsService)
    {
        $stats = $statsService->getDashboardStats();

        $recentInscriptions = Inscription::with('programme')
            ->latest()
            ->take(5)
            ->get();

        $recentMessages = Message::latest()
            ->take(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'recentInscriptions', 'recentMessages'));
    }
}
