<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function email()
    {
        $settings = Setting::first() ?? new Setting();
        return view('admin.settings.email', compact('settings'));
    }

    public function emailUpdate(Request $request)
    {
        $validated = $request->validate([
            'mail_mailer' => 'required|string|in:smtp,sendmail,log',
            'mail_host' => 'nullable|string|max:255',
            'mail_port' => 'required|string|max:10',
            'mail_username' => 'nullable|string|max:255',
            'mail_password' => 'nullable|string|max:255',
            'mail_encryption' => 'nullable|string|in:tls,ssl,null',
            'mail_from_address' => 'nullable|email|max:255',
            'mail_from_name' => 'nullable|string|max:255',
            'mail_enabled' => 'boolean',
        ]);

        $validated['mail_enabled'] = $request->has('mail_enabled');

        $settings = Setting::first();

        if ($settings) {
            $settings->update($validated);
        } else {
            Setting::create($validated);
        }

        return redirect()->route('admin.settings.email')->with('success', 'Configuration email mise a jour avec succes.');
    }

    public function general()
    {
        $settings = Setting::first() ?? new Setting();
        return view('admin.settings.general', compact('settings'));
    }

    public function generalUpdate(Request $request)
    {
        $validated = $request->validate([
            'annee_academique' => 'required|string|max:20',
            'inscriptions_ouvertes' => 'boolean',
        ]);

        $validated['inscriptions_ouvertes'] = $request->has('inscriptions_ouvertes');

        $settings = Setting::first();

        if ($settings) {
            $settings->update($validated);
        } else {
            Setting::create($validated);
        }

        return redirect()->route('admin.settings.general')->with('success', 'Parametres generaux mis a jour avec succes.');
    }
}
