<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Statistic;
use Illuminate\Http\Request;

class StatisticController extends Controller
{
    public function index()
    {
        $statistics = Statistic::ordre()->get();
        return view('admin.statistics.index', compact('statistics'));
    }

    public function create()
    {
        return view('admin.statistics.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'libelle' => 'required|string|max:255',
            'valeur' => 'required|string|max:50',
            'icone' => 'required|string|max:50',
            'actif' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['actif'] = $request->has('actif');
        $validated['ordre'] = $validated['ordre'] ?? Statistic::max('ordre') + 1;

        Statistic::create($validated);

        return redirect()->route('admin.statistics.index')
            ->with('success', 'Statistique créée avec succès.');
    }

    public function edit(Statistic $statistic)
    {
        return view('admin.statistics.edit', compact('statistic'));
    }

    public function update(Request $request, Statistic $statistic)
    {
        $validated = $request->validate([
            'libelle' => 'required|string|max:255',
            'valeur' => 'required|string|max:50',
            'icone' => 'required|string|max:50',
            'actif' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['actif'] = $request->has('actif');

        $statistic->update($validated);

        return redirect()->route('admin.statistics.index')
            ->with('success', 'Statistique mise à jour avec succès.');
    }

    public function destroy(Statistic $statistic)
    {
        $statistic->delete();

        return redirect()->route('admin.statistics.index')
            ->with('success', 'Statistique supprimée avec succès.');
    }
}
