<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Programme extends Model
{
    use HasFactory;

    protected $fillable = [
        'titre',
        'description',
        'pension',
        'statut',
    ];

    protected $casts = [
        'statut' => 'boolean',
        'pension' => 'decimal:2',
    ];

    public function inscriptions()
    {
        return $this->hasMany(Inscription::class);
    }
}
