<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'mail_mailer',
        'mail_host',
        'mail_port',
        'mail_username',
        'mail_password',
        'mail_encryption',
        'mail_from_address',
        'mail_from_name',
        'mail_enabled',
        'annee_academique',
        'inscriptions_ouvertes',
    ];

    protected $casts = [
        'mail_enabled' => 'boolean',
        'inscriptions_ouvertes' => 'boolean',
    ];

    public function setMailPasswordAttribute($value)
    {
        $this->attributes['mail_password'] = $value ? Crypt::encryptString($value) : null;
    }

    public function getMailPasswordAttribute($value)
    {
        if (!$value) {
            return null;
        }

        try {
            return Crypt::decryptString($value);
        } catch (\Exception $e) {
            return $value;
        }
    }

    public static function getMailSettings(): ?self
    {
        return self::first();
    }

    public static function isMailEnabled(): bool
    {
        $settings = self::first();
        return $settings && $settings->mail_enabled;
    }
}
