<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class MailConfigServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        if (!app()->runningInConsole() || app()->runningUnitTests()) {
            $this->configureMailFromDatabase();
        }
    }

    protected function configureMailFromDatabase(): void
    {
        try {
            if (!Schema::hasTable('settings')) {
                return;
            }

            $settings = Setting::first();

            if (!$settings || !$settings->mail_enabled) {
                return;
            }

            Config::set('mail.default', $settings->mail_mailer);
            Config::set('mail.mailers.smtp.host', $settings->mail_host);
            Config::set('mail.mailers.smtp.port', $settings->mail_port);
            Config::set('mail.mailers.smtp.username', $settings->mail_username);
            Config::set('mail.mailers.smtp.password', $settings->mail_password);
            Config::set('mail.mailers.smtp.encryption', $settings->mail_encryption === 'null' ? null : $settings->mail_encryption);
            Config::set('mail.from.address', $settings->mail_from_address);
            Config::set('mail.from.name', $settings->mail_from_name);

        } catch (\Exception $e) {
            // Silently fail if database is not available
        }
    }
}
