<?php

namespace Database\Seeders;

use App\Models\DocumentRequis;
use Illuminate\Database\Seeder;

class DocumentRequisSeeder extends Seeder
{
    public function run(): void
    {
        $documents = [
            [
                'intitule' => 'Photocopie du diplome (BAC ou equivalent)',
                'description' => null,
                'actif' => true,
                'ordre' => 1,
            ],
            [
                'intitule' => 'Photocopie de la CNI ou acte de naissance',
                'description' => null,
                'actif' => true,
                'ordre' => 2,
            ],
            [
                'intitule' => '4 photos d\'identite (4x4)',
                'description' => 'Format passeport, fond blanc',
                'actif' => true,
                'ordre' => 3,
            ],
            [
                'intitule' => 'Frais d\'inscription',
                'description' => null,
                'actif' => true,
                'ordre' => 4,
            ],
        ];

        foreach ($documents as $document) {
            DocumentRequis::create($document);
        }
    }
}
