<?php

namespace Database\Seeders;

use App\Models\Statistic;
use Illuminate\Database\Seeder;

class StatisticSeeder extends Seeder
{
    public function run(): void
    {
        $statistics = [
            [
                'libelle' => 'Taux de réussite',
                'valeur' => '95%',
                'icone' => 'chart',
                'actif' => true,
                'ordre' => 1,
            ],
            [
                'libelle' => 'Insertion professionnelle',
                'valeur' => '85%',
                'icone' => 'briefcase',
                'actif' => true,
                'ordre' => 2,
            ],
            [
                'libelle' => 'Entreprises partenaires',
                'valeur' => '50+',
                'icone' => 'briefcase',
                'actif' => true,
                'ordre' => 3,
            ],
            [
                'libelle' => "Années d'expérience",
                'valeur' => '15+',
                'icone' => 'clock',
                'actif' => true,
                'ordre' => 4,
            ],
        ];

        foreach ($statistics as $stat) {
            Statistic::create($stat);
        }
    }
}
