@extends('layouts.admin')

@section('page-title', 'Inscriptions')

@section('content')
<div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
    <!-- En-tête -->
    <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-red-50 to-white flex items-center gap-4">
        <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center shadow-lg shadow-red-200">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
            </svg>
        </div>
        <div>
            <h1 class="text-lg font-bold text-slate-800">Liste des inscriptions</h1>
            <p class="text-sm text-slate-500">Consultez et traitez les demandes d'inscription</p>
        </div>
    </div>

    @if(count($inscriptions) > 0)
        <!-- Tableau -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="bg-slate-50 border-b border-slate-100">
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Candidat</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Programme</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Statut</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-slate-600 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100">
                    @foreach($inscriptions as $inscription)
                        @php
                            $isNew = $inscription->statut === 'en_attente';
                        @endphp
                        <tr class="{{ $isNew ? 'bg-red-50/30' : '' }} hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-4">
                                    <div class="w-11 h-11 bg-gradient-to-br from-slate-200 to-slate-300 rounded-full flex items-center justify-center shadow-inner relative">
                                        <span class="text-sm font-bold text-slate-600">{{ strtoupper(substr($inscription->prenom, 0, 1) . substr($inscription->nom, 0, 1)) }}</span>
                                        @if($isNew)
                                            <span class="absolute -top-1 -right-1 w-4 h-4 bg-red-500 rounded-full border-2 border-white"></span>
                                        @endif
                                    </div>
                                    <div>
                                        <p class="font-bold text-slate-800">{{ $inscription->nom }} {{ $inscription->prenom }}</p>
                                        <p class="text-sm text-slate-500">{{ $inscription->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="font-medium text-slate-700">{{ $inscription->programme->titre ?? 'N/A' }}</span>
                            </td>
                            <td class="px-6 py-4">
                                @php
                                    $statutConfig = [
                                        'en_attente' => ['label' => 'En attente', 'bg' => 'bg-amber-100', 'text' => 'text-amber-700', 'border' => 'border-amber-200', 'dot' => 'bg-amber-500'],
                                        'acceptee' => ['label' => 'Acceptée', 'bg' => 'bg-emerald-100', 'text' => 'text-emerald-700', 'border' => 'border-emerald-200', 'dot' => 'bg-emerald-500'],
                                        'refusee' => ['label' => 'Refusée', 'bg' => 'bg-red-100', 'text' => 'text-red-700', 'border' => 'border-red-200', 'dot' => 'bg-red-500'],
                                    ];
                                    $config = $statutConfig[$inscription->statut] ?? ['label' => $inscription->statut, 'bg' => 'bg-slate-100', 'text' => 'text-slate-600', 'border' => 'border-slate-200', 'dot' => 'bg-slate-400'];
                                @endphp
                                <span class="inline-flex items-center px-3 py-1.5 text-xs font-bold rounded-full border {{ $config['bg'] }} {{ $config['text'] }} {{ $config['border'] }}">
                                    <span class="w-2 h-2 {{ $config['dot'] }} rounded-full mr-2"></span>
                                    {{ $config['label'] }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <p class="font-medium text-slate-700">{{ $inscription->created_at->format('d/m/Y') }}</p>
                                <p class="text-xs text-slate-400">{{ $inscription->created_at->format('H:i') }}</p>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center justify-end">
                                    <a href="{{ route('admin.inscriptions.show', $inscription) }}" class="inline-flex items-center px-4 py-2 text-sm font-bold text-sky-600 hover:text-white hover:bg-sky-600 bg-sky-50 rounded-lg transition-all">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                        </svg>
                                        Voir détail
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if(method_exists($inscriptions, 'links') && $inscriptions->hasPages())
            <div class="px-6 py-4 border-t border-slate-100 bg-slate-50">
                {{ $inscriptions->links() }}
            </div>
        @endif
    @else
        <!-- Empty State Premium -->
        <div class="px-6 py-20">
            <div class="max-w-md mx-auto text-center">
                <div class="w-24 h-24 bg-gradient-to-br from-red-500 to-red-600 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-xl shadow-red-200">
                    <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-2">Aucune inscription</h3>
                <p class="text-slate-500 mb-6">Les candidatures soumises via le site apparaîtront ici. Vous pourrez les consulter et les traiter.</p>
                <div class="flex items-center justify-center gap-2 text-sm text-slate-400">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Les nouvelles inscriptions arrivent automatiquement
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
