@extends('layouts.admin')

@section('page-title', 'Messages')

@section('content')
<div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
    <!-- En-tête -->
    <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-emerald-50 to-white flex items-center gap-4">
        <div class="w-12 h-12 bg-gradient-to-br from-emerald-400 to-emerald-600 rounded-xl flex items-center justify-center shadow-lg shadow-emerald-200">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
            </svg>
        </div>
        <div>
            <h1 class="text-lg font-bold text-slate-800">Messages de contact</h1>
            <p class="text-sm text-slate-500">Consultez et répondez aux messages reçus</p>
        </div>
    </div>

    @if(count($messages) > 0)
        <!-- Tableau -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="bg-slate-50 border-b border-slate-100">
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider w-28">Statut</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Expéditeur</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Sujet</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider w-32">Date</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-slate-600 uppercase tracking-wider w-28">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100">
                    @foreach($messages as $message)
                        <tr class="{{ !$message->lu ? 'bg-sky-50/40' : '' }} hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4">
                                @if(!$message->lu)
                                    <span class="inline-flex items-center px-3 py-1.5 text-xs font-bold rounded-full bg-sky-100 text-sky-700 border border-sky-200">
                                        <span class="w-2 h-2 bg-sky-500 rounded-full mr-2 animate-pulse"></span>
                                        Non lu
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-3 py-1.5 text-xs font-bold rounded-full bg-slate-100 text-slate-500 border border-slate-200">
                                        Lu
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 bg-gradient-to-br from-slate-200 to-slate-300 rounded-full flex items-center justify-center shadow-inner">
                                        <span class="text-sm font-bold text-slate-600">{{ strtoupper(substr($message->nom, 0, 2)) }}</span>
                                    </div>
                                    <div>
                                        <p class="font-bold text-slate-800 {{ !$message->lu ? '' : 'font-semibold text-slate-600' }}">{{ $message->nom }}</p>
                                        <p class="text-sm text-slate-500">{{ $message->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-slate-700 {{ !$message->lu ? 'font-semibold' : '' }}">{{ Str::limit($message->sujet, 50) }}</p>
                            </td>
                            <td class="px-6 py-4">
                                <p class="font-medium text-slate-700">{{ $message->created_at->format('d/m/Y') }}</p>
                                <p class="text-xs text-slate-400">{{ $message->created_at->format('H:i') }}</p>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center justify-end">
                                    <a href="{{ route('admin.messages.show', $message) }}" class="inline-flex items-center px-4 py-2 text-sm font-bold text-sky-600 hover:text-white hover:bg-sky-600 bg-sky-50 rounded-lg transition-all">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                        </svg>
                                        Lire
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if(method_exists($messages, 'links') && $messages->hasPages())
            <div class="px-6 py-4 border-t border-slate-100 bg-slate-50">
                {{ $messages->links() }}
            </div>
        @endif
    @else
        <!-- Empty State Premium -->
        <div class="px-6 py-20">
            <div class="max-w-md mx-auto text-center">
                <div class="w-24 h-24 bg-gradient-to-br from-emerald-400 to-emerald-600 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-xl shadow-emerald-200">
                    <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-2">Aucun message</h3>
                <p class="text-slate-500 mb-6">Les messages envoyés via le formulaire de contact apparaîtront ici. Vous pourrez y répondre directement.</p>
                <div class="flex items-center justify-center gap-2 text-sm text-slate-400">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Les nouveaux messages arrivent automatiquement
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
