@extends('layouts.admin')

@section('page-title', 'Detail message')

@section('content')
<div class="max-w-4xl">
    <!-- En-tête avec retour -->
    <div class="flex items-center gap-4 mb-6">
        <a href="{{ route('admin.messages.index') }}" class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-slate-600 hover:text-slate-900 bg-white hover:bg-slate-50 rounded-lg border border-slate-200 transition">
            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
            Retour a la liste
        </a>
    </div>

    <!-- Carte principale -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
        <!-- En-tête Premium -->
        <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-emerald-50 to-white">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div class="flex items-center gap-4">
                    <div class="w-14 h-14 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-2xl flex items-center justify-center shadow-lg shadow-emerald-200 text-white text-xl font-bold">
                        {{ strtoupper(substr($message->nom, 0, 2)) }}
                    </div>
                    <div>
                        <h1 class="text-xl font-bold text-slate-800">{{ $message->nom }}</h1>
                        <p class="text-sm text-slate-500">{{ $message->created_at->format('d/m/Y a H:i') }}</p>
                    </div>
                </div>
                @if(!$message->lu)
                    <span class="inline-flex items-center px-4 py-2 text-sm font-bold rounded-xl bg-gradient-to-r from-sky-100 to-sky-50 text-sky-700 border border-sky-200">
                        <span class="w-2 h-2 bg-sky-500 rounded-full mr-2 animate-pulse"></span>
                        Non lu
                    </span>
                @else
                    <span class="inline-flex items-center px-4 py-2 text-sm font-bold rounded-xl bg-gradient-to-r from-slate-100 to-slate-50 text-slate-600 border border-slate-200">
                        <span class="w-2 h-2 bg-slate-400 rounded-full mr-2"></span>
                        Lu
                    </span>
                @endif
            </div>
        </div>

        <!-- Contenu -->
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Informations expéditeur -->
                <div class="bg-gradient-to-br from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <h2 class="text-sm font-bold text-slate-800 mb-4 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-sky-400 to-sky-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                            </svg>
                        </span>
                        Expediteur
                    </h2>
                    <dl class="space-y-4">
                        <div class="flex items-start gap-3">
                            <span class="w-6 h-6 bg-slate-100 rounded flex items-center justify-center flex-shrink-0 mt-0.5">
                                <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                            </span>
                            <div>
                                <dt class="text-xs font-medium text-slate-500 uppercase tracking-wider">Nom</dt>
                                <dd class="mt-0.5 text-sm font-semibold text-slate-900">{{ $message->nom }}</dd>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <span class="w-6 h-6 bg-slate-100 rounded flex items-center justify-center flex-shrink-0 mt-0.5">
                                <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                            </span>
                            <div>
                                <dt class="text-xs font-medium text-slate-500 uppercase tracking-wider">Email</dt>
                                <dd class="mt-0.5 text-sm">
                                    <a href="mailto:{{ $message->email }}" class="text-sky-600 hover:text-sky-700 font-medium">{{ $message->email }}</a>
                                </dd>
                            </div>
                        </div>
                    </dl>
                </div>

                <!-- Sujet -->
                <div class="bg-gradient-to-br from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <h2 class="text-sm font-bold text-slate-800 mb-4 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-amber-400 to-amber-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                            </svg>
                        </span>
                        Sujet
                    </h2>
                    <p class="text-sm text-slate-700 font-semibold bg-white p-3 rounded-lg border border-slate-100">{{ $message->sujet }}</p>
                </div>
            </div>

            <!-- Message -->
            <div class="mt-6 bg-gradient-to-br from-emerald-50 to-white rounded-xl p-5 border border-emerald-100">
                <h2 class="text-sm font-bold text-slate-800 mb-3 flex items-center gap-3">
                    <span class="w-8 h-8 bg-gradient-to-br from-emerald-400 to-emerald-500 rounded-lg flex items-center justify-center shadow-sm">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                    </span>
                    Message
                </h2>
                <div class="bg-white rounded-lg p-4 border border-emerald-100">
                    <p class="text-slate-700 whitespace-pre-wrap leading-relaxed">{{ $message->message }}</p>
                </div>
            </div>

            <!-- Répondre -->
            <div class="mt-6 bg-gradient-to-br from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                <h2 class="text-sm font-bold text-slate-800 mb-4 flex items-center gap-3">
                    <span class="w-8 h-8 bg-gradient-to-br from-red-400 to-red-500 rounded-lg flex items-center justify-center shadow-sm">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/>
                        </svg>
                    </span>
                    Repondre
                </h2>

                @if(!$mailEnabled)
                    <div class="bg-gradient-to-r from-amber-50 to-amber-50/50 border border-amber-200 rounded-xl p-4 mb-4">
                        <div class="flex items-start gap-3">
                            <span class="w-8 h-8 bg-gradient-to-br from-amber-400 to-amber-500 rounded-lg flex items-center justify-center shadow-sm flex-shrink-0">
                                <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                                </svg>
                            </span>
                            <div>
                                <p class="text-sm font-semibold text-amber-800">L'envoi d'emails est desactive.</p>
                                <a href="{{ route('admin.settings.email') }}" class="text-sm font-medium text-amber-700 hover:text-amber-900 underline mt-1 inline-block">Configurer les parametres email</a>
                            </div>
                        </div>
                    </div>
                @endif

                <form action="{{ route('admin.messages.repondre', $message) }}" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label for="reponse" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                            <span class="w-6 h-6 bg-red-100 rounded-md flex items-center justify-center mr-2">
                                <svg class="w-3.5 h-3.5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"/>
                                </svg>
                            </span>
                            Votre reponse
                        </label>
                        <textarea name="reponse" id="reponse" rows="5" required {{ !$mailEnabled ? 'disabled' : '' }}
                                  class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition resize-none @error('reponse') border-red-400 ring-2 ring-red-100 @enderror {{ !$mailEnabled ? 'bg-slate-100 cursor-not-allowed' : '' }}"
                                  placeholder="Ecrivez votre reponse ici...">{{ old('reponse') }}</textarea>
                        @error('reponse')
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                {{ $message }}
                            </p>
                        @enderror
                    </div>
                    <button type="submit" {{ !$mailEnabled ? 'disabled' : '' }}
                            class="inline-flex items-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white text-sm font-bold rounded-xl transition shadow-lg shadow-red-200 {{ !$mailEnabled ? 'opacity-50 cursor-not-allowed' : '' }}">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                        </svg>
                        Envoyer la reponse
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
