@extends('layouts.admin')

@section('page-title', 'Statistiques')

@section('content')
<div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
    <!-- En-tête -->
    <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-purple-50 to-white flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 bg-gradient-to-br from-purple-400 to-purple-600 rounded-xl flex items-center justify-center shadow-lg shadow-purple-200">
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
            </div>
            <div>
                <h1 class="text-lg font-bold text-slate-800">Statistiques</h1>
                <p class="text-sm text-slate-500">Chiffres clés affichés sur le site</p>
            </div>
        </div>
        <a href="{{ route('admin.statistics.create') }}" class="inline-flex items-center justify-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white text-sm font-bold rounded-xl transition shadow-lg shadow-red-200">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Ajouter une statistique
        </a>
    </div>

    @if(count($statistics) > 0)
        <!-- Tableau -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="bg-slate-50 border-b border-slate-100">
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider w-20">Ordre</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Libellé</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Valeur</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider">Icône</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-slate-600 uppercase tracking-wider w-24">Statut</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-slate-600 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100">
                    @foreach($statistics as $statistic)
                        <tr class="hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center justify-center w-10 h-10 bg-gradient-to-br from-purple-100 to-purple-200 text-purple-700 text-sm font-bold rounded-xl">{{ $statistic->ordre }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <span class="font-bold text-slate-800">{{ $statistic->libelle }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-2xl font-bold text-red-600">{{ $statistic->valeur }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <code class="px-3 py-1.5 text-xs bg-slate-100 text-slate-700 rounded-lg font-mono font-bold">{{ $statistic->icone }}</code>
                            </td>
                            <td class="px-6 py-4">
                                @if($statistic->actif)
                                    <span class="inline-flex items-center px-3 py-1.5 text-xs font-bold rounded-full bg-emerald-100 text-emerald-700 border border-emerald-200">
                                        <span class="w-2 h-2 bg-emerald-500 rounded-full mr-2"></span>
                                        Actif
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-3 py-1.5 text-xs font-bold rounded-full bg-slate-100 text-slate-600 border border-slate-200">
                                        <span class="w-2 h-2 bg-slate-400 rounded-full mr-2"></span>
                                        Inactif
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="{{ route('admin.statistics.edit', $statistic) }}" class="inline-flex items-center px-4 py-2 text-sm font-bold text-sky-600 hover:text-white hover:bg-sky-600 bg-sky-50 rounded-lg transition-all">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                        </svg>
                                        Modifier
                                    </a>
                                    <form action="{{ route('admin.statistics.destroy', $statistic) }}" method="POST" class="inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette statistique ?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="inline-flex items-center px-4 py-2 text-sm font-bold text-red-600 hover:text-white hover:bg-red-600 bg-red-50 rounded-lg transition-all">
                                            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                            </svg>
                                            Supprimer
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <!-- Empty State Premium -->
        <div class="px-6 py-20">
            <div class="max-w-md mx-auto text-center">
                <div class="w-24 h-24 bg-gradient-to-br from-purple-400 to-purple-600 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-xl shadow-purple-200">
                    <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-2">Aucune statistique</h3>
                <p class="text-slate-500 mb-8">Ajoutez des chiffres clés pour mettre en valeur les résultats et la qualité de Mad Academy.</p>
                <a href="{{ route('admin.statistics.create') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white font-bold rounded-xl transition shadow-lg shadow-red-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                    Créer la première statistique
                </a>
            </div>
        </div>
    @endif
</div>
@endsection
