@props(['title', 'subtitle' => null, 'ctaText', 'ctaUrl', 'image' => null])

<!-- CTA Banner avec Image -->
<section class="relative py-24 overflow-hidden">
    <!-- Background -->
    @if($image)
        <div class="absolute inset-0">
            <img src="{{ asset('images/' . $image) }}" alt="" class="w-full h-full object-cover">
            <div class="absolute inset-0 bg-gradient-to-r from-primary-900/95 to-primary-800/90"></div>
        </div>
    @else
        <div class="absolute inset-0 bg-gradient-to-r from-primary-900 to-primary-800"></div>
    @endif

    <!-- Content -->
    <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-white mb-6 font-serif tracking-tight leading-tight">
            {{ $title }}
        </h2>
        @if($subtitle)
            <p class="text-xl text-primary-100 mb-10 max-w-2xl mx-auto">
                {{ $subtitle }}
            </p>
        @endif
        <a href="{{ $ctaUrl }}"
           class="inline-flex items-center px-10 py-5 bg-white text-primary-900 text-lg font-bold tracking-tight rounded-lg hover:bg-primary-50 transition shadow-2xl hover:shadow-3xl">
            {{ $ctaText }}
            <svg class="w-6 h-6 ml-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
            </svg>
        </a>
    </div>
</section>
