@props(['faqs'])

<!-- FAQ Accordion avec Alpine.js -->
<section class="py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Header -->
        <div class="text-center mb-12">
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">
                Questions fréquentes
            </h2>
            <p class="text-lg text-slate-600">
                Retrouvez ici les réponses aux questions les plus courantes.
            </p>
        </div>

        <!-- Accordion -->
        <div class="space-y-4" x-data="{ activeIndex: null }">
            @foreach($faqs as $index => $faq)
                <div class="bg-white rounded-lg shadow-md overflow-hidden border border-slate-200">

                    <!-- Question Button -->
                    <button @click="activeIndex = activeIndex === {{ $index }} ? null : {{ $index }}"
                            class="w-full px-6 py-5 text-left flex items-center justify-between hover:bg-slate-50 transition">
                        <span class="text-lg font-semibold text-slate-900 pr-8">
                            {{ $faq->question }}
                        </span>
                        <svg class="w-6 h-6 text-primary-600 flex-shrink-0 transition-transform duration-300"
                             :class="activeIndex === {{ $index }} ? 'rotate-180' : ''"
                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                        </svg>
                    </button>

                    <!-- Answer Panel -->
                    <div x-show="activeIndex === {{ $index }}"
                         x-collapse
                         class="px-6 pb-5">
                        <div class="pt-2 text-slate-600 leading-relaxed border-t border-slate-100">
                            {{ $faq->reponse }}
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- CTA Footer -->
        <div class="mt-12 text-center p-8 bg-primary-50 rounded-xl">
            <p class="text-slate-700 mb-4">
                Vous avez besoin d’une précision ?
            </p>
            <a href="{{ route('contact') }}"
               class="inline-flex items-center px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold tracking-tight rounded-lg transition shadow-md hover:shadow-lg">
                Contactez-nous
                <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                </svg>
            </a>
        </div>
    </div>
</section>
