@props(['title', 'subtitle' => null, 'breadcrumb' => true])

<!-- Hero Page Interne -->
<section class="relative bg-gradient-to-r from-primary-900 to-primary-800 py-20 overflow-hidden">
    <!-- Pattern Background -->
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'1\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Breadcrumb -->
        @if($breadcrumb)
            <nav class="flex mb-8" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-2 text-sm">
                    <li class="inline-flex items-center">
                        <a href="{{ route('accueil') }}" class="text-primary-200 hover:text-white transition">
                            Accueil
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-primary-300 mx-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                            </svg>
                            <span class="text-white font-medium">{{ $title }}</span>
                        </div>
                    </li>
                </ol>
            </nav>
        @endif>

        <!-- Title -->
        <div class="text-center max-w-4xl mx-auto">
            <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-white mb-6 font-serif tracking-tight leading-tight">
                {{ $title }}
            </h1>
            @if($subtitle)
                <p class="text-xl text-primary-100 leading-relaxed">
                    {{ $subtitle }}
                </p>
            @endif
        </div>
    </div>
</section>
