@props(['programme'])

<!-- Programme Card Component -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-shadow duration-300 group">
    <!-- Image -->
    <div class="relative h-56 overflow-hidden bg-slate-200">
        @if($programme->image)
            <img src="{{ asset('storage/' . $programme->image) }}"
                 alt="{{ $programme->nom }}"
                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
        @else
            <div class="w-full h-full flex items-center justify-center bg-gradient-to-br from-primary-500 to-primary-700">
                <svg class="w-20 h-20 text-white opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                </svg>
            </div>
        @endif

        <!-- Badge Niveau -->
        <div class="absolute top-4 right-4">
            <span class="inline-block px-3 py-1 bg-white/90 backdrop-blur-sm text-primary-900 text-sm font-bold rounded-full shadow-lg">
                {{ $programme->niveau }}
            </span>
        </div>
    </div>

    <!-- Content -->
    <div class="p-6">
        <!-- Titre -->
        <h3 class="text-xl font-bold text-slate-900 mb-3 line-clamp-2 group-hover:text-primary-600 transition font-serif tracking-tight leading-tight">
            {{ $programme->nom }}
        </h3>

        <!-- Description -->
        <p class="text-slate-600 text-sm mb-4 line-clamp-3">
            {{ $programme->description }}
        </p>

        <!-- Metadata -->
        <div class="flex items-center gap-4 text-sm text-slate-500 mb-6">
            <div class="flex items-center gap-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span>{{ $programme->duree }}</span>
            </div>
            <div class="flex items-center gap-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                </svg>
                <span>{{ $programme->places_disponibles }} places</span>
            </div>
        </div>

        <!-- CTA Button -->
        <a href="{{ route('inscription.create', ['programme_id' => $programme->id]) }}"
           class="block w-full text-center px-6 py-3 bg-red-600 hover:bg-red-700 text-white font-semibold tracking-tight rounded-lg transition shadow-md hover:shadow-lg">
            S’inscrire
        </a>
    </div>
</div>
