@props(['logos' => []])

<!-- Trust Bar - Logos Partenaires/Accreditations -->
<section class="py-12 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-8">
            <p class="text-sm font-semibold text-slate-600 uppercase tracking-wide">
                Partenaires & reconnaissances
            </p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-8 items-center">
            @forelse($logos as $logo)
                <div class="flex items-center justify-center grayscale hover:grayscale-0 transition duration-300">
                    <img src="{{ asset('images/partners/' . $logo['image']) }}"
                         alt="{{ $logo['name'] }}"
                         class="h-12 w-auto object-contain opacity-60 hover:opacity-100 transition">
                </div>
            @empty
                <!-- Placeholders si aucun logo -->
                @for($i = 1; $i <= 6; $i++)
                    <div class="flex items-center justify-center">
                        <div class="h-12 w-24 bg-slate-200 rounded flex items-center justify-center text-slate-400 text-xs">
                            Logo {{ $i }}
                        </div>
                    </div>
                @endfor
            @endforelse
        </div>
    </div>
</section>
