<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'Mad Academy') }} - Administration</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700;800&family=Playfair+Display:wght@400;500;600;700&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        .sidebar-scroll::-webkit-scrollbar { width: 4px; }
        .sidebar-scroll::-webkit-scrollbar-track { background: transparent; }
        .sidebar-scroll::-webkit-scrollbar-thumb { background: #e2e8f0; border-radius: 2px; }
        .sidebar-scroll::-webkit-scrollbar-thumb:hover { background: #cbd5e1; }
        .nav-item-active { position: relative; }
        .nav-item-active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 3px;
            height: 70%;
            background: linear-gradient(to bottom, #dc2626, #b91c1c);
            border-radius: 0 4px 4px 0;
        }
    </style>
</head>
<body class="font-sans antialiased bg-slate-50" x-data="{ sidebarOpen: false }">
    <div class="min-h-screen flex">

        <!-- Mobile Sidebar Overlay -->
        <div x-show="sidebarOpen"
             x-transition:enter="transition-opacity ease-linear duration-200"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             @click="sidebarOpen = false"
             class="fixed inset-0 bg-slate-900/50 z-40 lg:hidden"
             style="display: none;"></div>

        <!-- Sidebar -->
        <aside :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'"
               class="fixed top-0 left-0 z-50 h-full w-64 bg-white border-r border-slate-200 shadow-sm transition-transform duration-200 ease-in-out lg:translate-x-0 lg:static lg:z-auto flex flex-col">

            <!-- Logo -->
            <div class="h-16 flex items-center px-5 border-b border-slate-100 flex-shrink-0 bg-gradient-to-r from-red-50 to-white">
                <a href="{{ route('admin.dashboard') }}" class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center shadow-lg shadow-red-200">
                        <span class="text-white font-bold text-sm">MA</span>
                    </div>
                    <div>
                        <span class="text-base font-bold text-slate-800">Mad Academy</span>
                        <span class="block text-[10px] text-red-500 uppercase tracking-wider font-semibold -mt-0.5">Administration</span>
                    </div>
                </a>
            </div>

            <!-- Navigation -->
            <nav class="flex-1 p-4 space-y-1 sidebar-scroll overflow-y-auto">
                <!-- Dashboard -->
                <a href="{{ route('admin.dashboard') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.dashboard') ? 'nav-item-active bg-gradient-to-r from-red-50 to-red-50/50 text-red-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.dashboard') ? 'bg-gradient-to-br from-red-500 to-red-600 shadow-md shadow-red-200' : 'bg-gradient-to-br from-red-100 to-red-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.dashboard') ? 'text-white' : 'text-red-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                        </svg>
                    </div>
                    Tableau de bord
                </a>

                <!-- Section: Gestion -->
                <div class="pt-5 pb-2">
                    <p class="px-3 text-[10px] font-bold text-slate-400 uppercase tracking-wider flex items-center">
                        <span class="w-6 h-px bg-slate-200 mr-2"></span>
                        Gestion
                        <span class="flex-1 h-px bg-slate-200 ml-2"></span>
                    </p>
                </div>

                <!-- Programmes -->
                <a href="{{ route('admin.programmes.index') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.programmes.*') ? 'nav-item-active bg-gradient-to-r from-sky-50 to-sky-50/50 text-sky-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.programmes.*') ? 'bg-gradient-to-br from-sky-500 to-sky-600 shadow-md shadow-sky-200' : 'bg-gradient-to-br from-sky-100 to-sky-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.programmes.*') ? 'text-white' : 'text-sky-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                        </svg>
                    </div>
                    Programmes
                </a>

                <!-- Inscriptions -->
                <a href="{{ route('admin.inscriptions.index') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.inscriptions.*') ? 'nav-item-active bg-gradient-to-r from-red-50 to-red-50/50 text-red-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.inscriptions.*') ? 'bg-gradient-to-br from-red-500 to-red-600 shadow-md shadow-red-200' : 'bg-gradient-to-br from-red-100 to-red-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.inscriptions.*') ? 'text-white' : 'text-red-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"/>
                        </svg>
                    </div>
                    Inscriptions
                    @php $newInscriptions = \App\Models\Inscription::where('statut', 'nouvelle')->count(); @endphp
                    @if($newInscriptions > 0)
                        <span class="ml-auto bg-gradient-to-r from-red-500 to-red-600 text-white text-[10px] font-bold px-2 py-0.5 rounded-full shadow-sm animate-pulse">{{ $newInscriptions }}</span>
                    @endif
                </a>

                <!-- Messages -->
                <a href="{{ route('admin.messages.index') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.messages.*') ? 'nav-item-active bg-gradient-to-r from-emerald-50 to-emerald-50/50 text-emerald-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.messages.*') ? 'bg-gradient-to-br from-emerald-500 to-emerald-600 shadow-md shadow-emerald-200' : 'bg-gradient-to-br from-emerald-100 to-emerald-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.messages.*') ? 'text-white' : 'text-emerald-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                    </div>
                    Messages
                    @php $unreadMessages = \App\Models\Message::where('lu', false)->count(); @endphp
                    @if($unreadMessages > 0)
                        <span class="ml-auto bg-gradient-to-r from-sky-500 to-sky-600 text-white text-[10px] font-bold px-2 py-0.5 rounded-full shadow-sm">{{ $unreadMessages }}</span>
                    @endif
                </a>

                <!-- Section: Contenu -->
                <div class="pt-5 pb-2">
                    <p class="px-3 text-[10px] font-bold text-slate-400 uppercase tracking-wider flex items-center">
                        <span class="w-6 h-px bg-slate-200 mr-2"></span>
                        Contenu
                        <span class="flex-1 h-px bg-slate-200 ml-2"></span>
                    </p>
                </div>

                <!-- FAQs -->
                <a href="{{ route('admin.faqs.index') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.faqs.*') ? 'nav-item-active bg-gradient-to-r from-amber-50 to-amber-50/50 text-amber-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.faqs.*') ? 'bg-gradient-to-br from-amber-500 to-amber-600 shadow-md shadow-amber-200' : 'bg-gradient-to-br from-amber-100 to-amber-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.faqs.*') ? 'text-white' : 'text-amber-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    FAQs
                </a>

                <!-- Statistiques -->
                <a href="{{ route('admin.statistics.index') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.statistics.*') ? 'nav-item-active bg-gradient-to-r from-purple-50 to-purple-50/50 text-purple-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.statistics.*') ? 'bg-gradient-to-br from-purple-500 to-purple-600 shadow-md shadow-purple-200' : 'bg-gradient-to-br from-purple-100 to-purple-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.statistics.*') ? 'text-white' : 'text-purple-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                    </div>
                    Statistiques
                </a>

                <!-- Documents -->
                <a href="{{ route('admin.documents.index') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.documents.*') ? 'nav-item-active bg-gradient-to-r from-teal-50 to-teal-50/50 text-teal-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.documents.*') ? 'bg-gradient-to-br from-teal-500 to-teal-600 shadow-md shadow-teal-200' : 'bg-gradient-to-br from-teal-100 to-teal-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.documents.*') ? 'text-white' : 'text-teal-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                    </div>
                    Documents requis
                </a>

                <!-- Section: Configuration -->
                <div class="pt-5 pb-2">
                    <p class="px-3 text-[10px] font-bold text-slate-400 uppercase tracking-wider flex items-center">
                        <span class="w-6 h-px bg-slate-200 mr-2"></span>
                        Configuration
                        <span class="flex-1 h-px bg-slate-200 ml-2"></span>
                    </p>
                </div>

                <!-- Paramètres généraux -->
                <a href="{{ route('admin.settings.general') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.settings.general') ? 'nav-item-active bg-gradient-to-r from-slate-100 to-slate-50 text-slate-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.settings.general') ? 'bg-gradient-to-br from-slate-600 to-slate-700 shadow-md shadow-slate-300' : 'bg-gradient-to-br from-slate-200 to-slate-100' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.settings.general') ? 'text-white' : 'text-slate-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                    </div>
                    Paramètres généraux
                </a>

                <!-- Paramètres email -->
                <a href="{{ route('admin.settings.email') }}"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl transition-all {{ request()->routeIs('admin.settings.email') ? 'nav-item-active bg-gradient-to-r from-sky-50 to-sky-50/50 text-sky-700' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 {{ request()->routeIs('admin.settings.email') ? 'bg-gradient-to-br from-sky-500 to-sky-600 shadow-md shadow-sky-200' : 'bg-gradient-to-br from-sky-100 to-sky-50' }}">
                        <svg class="w-4 h-4 {{ request()->routeIs('admin.settings.email') ? 'text-white' : 'text-sky-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"/>
                        </svg>
                    </div>
                    Configuration email
                </a>
            </nav>

            <!-- Bottom: Voir le site -->
            <div class="p-4 border-t border-slate-100 flex-shrink-0 bg-gradient-to-r from-slate-50 to-white">
                <a href="{{ route('accueil') }}" target="_blank"
                   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-xl text-slate-600 hover:bg-sky-50 hover:text-sky-700 transition-all group">
                    <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3 bg-gradient-to-br from-slate-100 to-slate-50 group-hover:from-sky-100 group-hover:to-sky-50 transition-all">
                        <svg class="w-4 h-4 text-slate-400 group-hover:text-sky-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                        </svg>
                    </div>
                    Voir le site
                    <svg class="w-3 h-3 ml-auto text-slate-300 group-hover:text-sky-400 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col min-w-0">
            <!-- Top Header -->
            <header class="sticky top-0 z-30 h-16 bg-white/95 backdrop-blur-sm border-b border-slate-200 flex items-center px-4 sm:px-6 shadow-sm">
                <!-- Mobile menu button -->
                <button @click="sidebarOpen = !sidebarOpen" class="lg:hidden p-2 -ml-2 rounded-lg text-slate-500 hover:bg-slate-100 transition">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                </button>

                <!-- Page title -->
                <div class="flex-1 ml-4 lg:ml-0">
                    <h1 class="text-lg font-bold text-slate-800">@yield('page-title', 'Tableau de bord')</h1>
                </div>

                <!-- Right side -->
                <div class="flex items-center space-x-3">
                    <!-- User dropdown -->
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" class="flex items-center space-x-2 p-1.5 rounded-xl hover:bg-slate-100 transition">
                            <div class="w-9 h-9 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center shadow-md shadow-red-200">
                                <span class="text-white text-sm font-bold">{{ substr(Auth::user()->name, 0, 1) }}</span>
                            </div>
                            <span class="hidden sm:block text-sm font-semibold text-slate-700">{{ Auth::user()->name }}</span>
                            <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>

                        <!-- Dropdown -->
                        <div x-show="open" @click.away="open = false"
                             x-transition:enter="transition ease-out duration-100"
                             x-transition:enter-start="opacity-0 scale-95"
                             x-transition:enter-end="opacity-100 scale-100"
                             x-transition:leave="transition ease-in duration-75"
                             x-transition:leave-start="opacity-100 scale-100"
                             x-transition:leave-end="opacity-0 scale-95"
                             class="absolute right-0 mt-2 w-56 bg-white rounded-xl shadow-xl border border-slate-200 py-1 z-50"
                             style="display: none;">
                            <div class="px-4 py-3 border-b border-slate-100 bg-gradient-to-r from-slate-50 to-white rounded-t-xl">
                                <p class="text-sm font-bold text-slate-900">{{ Auth::user()->name }}</p>
                                <p class="text-xs text-slate-500 mt-0.5">{{ Auth::user()->email }}</p>
                            </div>
                            <form method="POST" action="{{ route('logout') }}" class="p-1">
                                @csrf
                                <button type="submit" class="w-full flex items-center px-3 py-2 text-sm font-medium text-red-600 hover:bg-red-50 rounded-lg transition">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                    </svg>
                                    Deconnexion
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 p-4 sm:p-6 overflow-auto">
                <!-- Flash Messages -->
                @if(session('success'))
                    <div class="mb-5 p-4 bg-gradient-to-r from-emerald-50 to-emerald-50/50 border border-emerald-200 rounded-xl flex items-start shadow-sm" x-data="{ show: true }" x-show="show" x-transition>
                        <div class="w-8 h-8 bg-gradient-to-br from-emerald-400 to-emerald-500 rounded-lg flex items-center justify-center mr-3 flex-shrink-0 shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                        <p class="text-sm text-emerald-700 font-medium flex-1 pt-1">{{ session('success') }}</p>
                        <button @click="show = false" class="text-emerald-400 hover:text-emerald-600 transition p-1">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mb-5 p-4 bg-gradient-to-r from-red-50 to-red-50/50 border border-red-200 rounded-xl flex items-start shadow-sm" x-data="{ show: true }" x-show="show" x-transition>
                        <div class="w-8 h-8 bg-gradient-to-br from-red-400 to-red-500 rounded-lg flex items-center justify-center mr-3 flex-shrink-0 shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </div>
                        <p class="text-sm text-red-700 font-medium flex-1 pt-1">{{ session('error') }}</p>
                        <button @click="show = false" class="text-red-400 hover:text-red-600 transition p-1">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                @endif

                @yield('content')
            </main>
        </div>
    </div>
</body>
</html>
