<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="Mad Academy — Centre de formation professionnelle. Des parcours pratiques et professionnalisants, orientés métiers, pour développer des compétences solides et réussir votre insertion.">
    <meta name="keywords" content="mad academy, centre de formation, formation professionnelle, métiers, insertion professionnelle, Douala, Cameroun, DQP, CQP, AQP, informatique, gestion, numérique, imprimerie">
    <meta property="og:title" content="Centre de formation professionnelle">
    <meta property="og:description" content="Centre de formation professionnelle. Des parcours orientés métiers, un encadrement rigoureux et des compétences directement applicables.">
    <meta property="og:type" content="website">
    <title>Centre de formation professionnelle</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Playfair+Display:wght@600;700;800&display=swap" rel="stylesheet">

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased text-slate-900 bg-white">
    <div class="min-h-screen flex flex-col">
        <!-- Navigation Component -->
        <x-navbar />

        <!-- Main Content -->
        <main class="flex-grow">
            @yield('content')
        </main>

        <!-- Footer Component -->
        <x-footer />
    </div>
</body>
</html>
