<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ProgrammeController;
use App\Http\Controllers\Admin\InscriptionController;
use App\Http\Controllers\Admin\MessageController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\StatisticController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\DocumentRequisController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Routes publiques Front-office
Route::get('/', [FrontController::class, 'accueil'])->name('accueil');
Route::get('/a-propos', [FrontController::class, 'aPropos'])->name('a-propos');
Route::get('/programmes', [FrontController::class, 'programmes'])->name('programmes');
Route::get('/inscription', [FrontController::class, 'inscription'])->name('inscription');
Route::post('/inscription', [FrontController::class, 'inscriptionStore'])->name('inscription.store');
Route::get('/contact', [FrontController::class, 'contact'])->name('contact');
Route::post('/contact', [FrontController::class, 'contactStore'])->name('contact.store');

// Routes Admin protégées par authentification
Route::middleware('auth')->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::resource('programmes', ProgrammeController::class);
    Route::get('/inscriptions', [InscriptionController::class, 'index'])->name('inscriptions.index');
    Route::get('/inscriptions/{inscription}', [InscriptionController::class, 'show'])->name('inscriptions.show');
    Route::patch('/inscriptions/{inscription}/statut', [InscriptionController::class, 'updateStatut'])->name('inscriptions.updateStatut');
    Route::get('/messages', [MessageController::class, 'index'])->name('messages.index');
    Route::get('/messages/{message}', [MessageController::class, 'show'])->name('messages.show');
    Route::post('/messages/{message}/repondre', [MessageController::class, 'repondre'])->name('messages.repondre');
    Route::get('/settings/email', [SettingController::class, 'email'])->name('settings.email');
    Route::post('/settings/email', [SettingController::class, 'emailUpdate'])->name('settings.email.update');
    Route::get('/settings/general', [SettingController::class, 'general'])->name('settings.general');
    Route::post('/settings/general', [SettingController::class, 'generalUpdate'])->name('settings.general.update');
    Route::resource('statistics', StatisticController::class);
    Route::resource('faqs', FaqController::class);
    Route::resource('documents', DocumentRequisController::class);
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
