<!-- Navigation Premium Sticky -->
<nav class="bg-white/95 backdrop-blur-md shadow-[0_1px_0_rgba(15,23,42,0.06)] sticky top-0 z-50 border-b border-slate-200/70" x-data="{ mobileMenuOpen: false }">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16 md:h-18">
            <!-- Logo -->
            <a href="<?php echo e(route('accueil')); ?>" class="flex items-center space-x-2 group">
                <div class="w-10 h-10 bg-sky-50 border border-sky-200 rounded-xl flex items-center justify-center text-red-600 font-semibold tracking-tight shadow-sm group-hover:border-sky-300 transition">
                    <span class="text-sm">MA</span>
                </div>
                <span class="text-xl font-semibold text-slate-900 tracking-tight">Mad Academy</span>
            </a>

            <!-- Desktop Navigation - visible dès md (768px) -->
            <div class="hidden md:flex items-center gap-8">
                <a href="<?php echo e(route('accueil')); ?>"
                   class="px-3 lg:px-4 py-2 text-sm font-medium transition rounded-lg <?php echo e(request()->routeIs('accueil') ? 'text-red-600 bg-sky-50 ring-1 ring-sky-100' : 'text-slate-700 hover:text-red-600 hover:bg-sky-50'); ?>">
                    Accueil
                </a>
                <a href="<?php echo e(route('a-propos')); ?>"
                   class="px-3 lg:px-4 py-2 text-sm font-medium transition rounded-lg <?php echo e(request()->routeIs('a-propos') ? 'text-red-600 bg-sky-50 ring-1 ring-sky-100' : 'text-slate-700 hover:text-red-600 hover:bg-sky-50'); ?>">
                    À propos
                </a>
                <a href="<?php echo e(route('programmes')); ?>"
                   class="px-3 lg:px-4 py-2 text-sm font-medium transition rounded-lg <?php echo e(request()->routeIs('programmes') ? 'text-red-600 bg-sky-50 ring-1 ring-sky-100' : 'text-slate-700 hover:text-red-600 hover:bg-sky-50'); ?>">
                    Programmes
                </a>
                <a href="<?php echo e(route('contact')); ?>"
                   class="px-3 lg:px-4 py-2 text-sm font-medium transition rounded-lg <?php echo e(request()->routeIs('contact') ? 'text-red-600 bg-sky-50 ring-1 ring-sky-100' : 'text-slate-700 hover:text-red-600 hover:bg-sky-50'); ?>">
                    Contact
                </a>
                <a href="<?php echo e(route('inscription')); ?>"
                   class="mx-2 inline-flex items-center justify-center px-6 py-3 bg-red-600 hover:bg-red-700 text-white text-sm font-semibold tracking-tight rounded-xl transition shadow-sm hover:shadow-md ring-1 ring-red-500/20 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-sky-300 focus-visible:ring-offset-2">
                    S'inscrire
                </a>
            </div>

            <!-- Mobile menu button - visible uniquement < md -->
            <button @click="mobileMenuOpen = !mobileMenuOpen" type="button"
                    class="md:hidden p-2 rounded-lg text-slate-700 hover:bg-slate-100 transition">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path x-show="!mobileMenuOpen" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                    <path x-show="mobileMenuOpen" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div x-show="mobileMenuOpen"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 -translate-y-2"
         x-transition:enter-end="opacity-100 translate-y-0"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100 translate-y-0"
         x-transition:leave-end="opacity-0 -translate-y-2"
         @click.away="mobileMenuOpen = false"
         class="md:hidden bg-white border-t border-slate-100 shadow-lg"
         style="display: none;">
        <div class="px-4 py-4 space-y-1">
            <a href="<?php echo e(route('accueil')); ?>" class="block px-4 py-2.5 rounded-lg text-base font-medium <?php echo e(request()->routeIs('accueil') ? 'bg-sky-50 text-red-600 ring-1 ring-sky-100' : 'text-slate-700 hover:bg-sky-50 hover:text-red-600'); ?>">
                Accueil
            </a>
            <a href="<?php echo e(route('a-propos')); ?>" class="block px-4 py-2.5 rounded-lg text-base font-medium <?php echo e(request()->routeIs('a-propos') ? 'bg-sky-50 text-red-600 ring-1 ring-sky-100' : 'text-slate-700 hover:bg-sky-50 hover:text-red-600'); ?>">
                À propos
            </a>
            <a href="<?php echo e(route('programmes')); ?>" class="block px-4 py-2.5 rounded-lg text-base font-medium <?php echo e(request()->routeIs('programmes') ? 'bg-sky-50 text-red-600 ring-1 ring-sky-100' : 'text-slate-700 hover:bg-sky-50 hover:text-red-600'); ?>">
                Programmes
            </a>
            <a href="<?php echo e(route('contact')); ?>" class="block px-4 py-2.5 rounded-lg text-base font-medium <?php echo e(request()->routeIs('contact') ? 'bg-sky-50 text-red-600 ring-1 ring-sky-100' : 'text-slate-700 hover:bg-sky-50 hover:text-red-600'); ?>">
                Contact
            </a>
            <div class="pt-2">
                <a href="<?php echo e(route('inscription')); ?>" class="block mx-1 px-6 py-3 bg-red-600 hover:bg-red-700 text-white text-base font-semibold tracking-tight rounded-xl text-center shadow-sm ring-1 ring-red-500/20 transition focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-sky-300 focus-visible:ring-offset-2">
                    S'inscrire
                </a>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH C:\wamp64\www\madacademie\resources\views/components/navbar.blade.php ENDPATH**/ ?>